/**************************************************************************//**
 * @file        ADC12B.c
 * @version     V1.00.01
 * $Revision:   0 $
 * $Date:       2017-01-10 $
 * @brief       12Bits SAR ADC Driver source file
 *
 * @note
 *
 * Copyright (C) 2017 AMICCOM Electronics Corp. All rights reserved.
 *****************************************************************************/

#include "A9139M0.h"
#include "Delay.h"
/** @addtogroup Std_Driver Standard Driver
    @{
*/
/** @addtogroup ADC12B_Driver ADC12B Driver
    @{
*/

/**
 *
 * @brief   Initial 12Bits SAR ADC and Start running with adcch
 *
 * @param   *adc12b                 ADC12B Pointer
 * @param   ch                      Select ADC Channel. Value=0~7.
 * @return  ADC value by moving average 8 times
 */
uint32_t ADC12B_Measure(ADC12B_Type *adc12b, uint32_t ch)
{
    uint32_t control = 0;
    uint32_t mvadc;

    adc12b->Control = ADC12B_CONTROL_ADC12RN_Msk;   // ADC reset
    control = ADC12B_CONTROL_ADCE_Msk |         // start ADC measure
            (6 << ADC12B_CONTROL_VADS_Pos) |    // Ref Voltage = 1.8V
            (3 << ADC12B_CONTROL_MVS_Pos) |     // Average 8 times
            (0 << ADC12B_CONTROL_CKS_Pos) |     // clock 3.2MHz
            ADC12B_CONTROL_ENADC_Msk |          // ADC clock on
            ADC12B_CONTROL_MODE_Msk;            // continue mode

    switch(ch)
    {
        case 0:
            GPIO0->OUTENABLECLR = ( 1 << 18 );  // set to input
            GPIO0->PUN_PIN.P18 = 1;             // disable pull-high
            break;
        case 1:
            GPIO0->OUTENABLECLR = ( 1 << 19 );  // set to input
            GPIO0->PUN_PIN.P19 = 1;             // disable pull-high
            break;
        case 2:
            GPIO0->OUTENABLECLR = ( 1 << 8 );   // set to input
            GPIO0->PUN_PIN.P08 = 1;             // disable pull-high
            break;
        case 3:
            GPIO0->OUTENABLECLR = ( 1 << 9 );   // set to input
            GPIO0->PUN_PIN.P09 = 1;             // disable pull-high
            break;
        case 4:
            GPIO0->OUTENABLECLR = ( 1 << 12 );  // set to input
            GPIO0->PUN_PIN.P12 = 1;             // disable pull-high
            break;
        case 5:
            GPIO0->OUTENABLECLR = ( 1 << 13 );  // set to input
            GPIO0->PUN_PIN.P13 = 1;             // disable pull-high
            break;
        case 6:
            GPIO0->OUTENABLECLR = ( 1 << 14 );  // set to input
            GPIO0->PUN_PIN.P14 = 1;             // disable pull-high
            break;
        case 7:
            GPIO0->OUTENABLECLR = ( 1 << 15 );  // set to input
            GPIO0->PUN_PIN.P15 = 1;             // disable pull-high
            break;
    }
    adc12b->ADCIOS = ((ch << ADC12B_IOSEL_CH_Pos) & ADC12B_IOSEL_CH_Msk) | ADC12B_IOSEL_EN_Msk;

    adc12b->Control = control;                  // ADC measure start

    //-----------------------------------------------------
    // Delay for ADC measure
    // delay time = 2*(32*8)/3.2M = 160us
    // To avoid reading errors, add 20us to the time
    Delay10us(18);
    //-----------------------------------------------------

    mvadc = adc12b->ValueItem.MVADC;            // read mvadc value
    adc12b->Control = 0;                        // close ADC 12Bits
    adc12b->ADCIOS = 0;                          // close ADC channel

    return mvadc;
}

/*@}*/ /* end of group ADC12B_Driver */
/*@}*/ /* end of group Std_Driver */

